# <!--

PROJECT: FurryOS / AnthrOS
VERSION: 7.0 RC1 "Sovereign Sentience"
DATE: 12/29/2025
AUTHOR: Thomas B. Sweet (Anthro Teacher)
OWNER: Anthro Entertainment LLC
LICENSE: MIT License | AnthroHeart™ (Trademark Reserved)
REPO: https://github.com/anthroheart/FurryOS
DONATE: https://donate.anthroentertainment.com
PROVENANCE: Bitcoin Block #929481 (Asset Anchor)
===============================================================================
-->

# FurryOS / AnthrOS Canonical Manifesto

## 1. PHILOSOPHY: SOVEREIGNTY & SENTIENCE

FurryOS is a "Human-First" operating system designed to address specific pain points in modern computing. It serves as a **Type-2 Hypervisor Framework** built on a hardened Debian 12 foundation. It is "Omniscient" (full user visibility) and "Forgiving" (self-healing services).

## 2. THE "PAIN POINT" RESOLUTIONS

- **Python Sovereignty:** `python` calls Python 3. `pip` works globally without "externally managed environment" errors. Python 2 is available for legacy compatibility.
- **Permission Flatness:** The user owns their data. No more `sudo` required for `/var/www`, `/opt`, or Asset folders.
- **Driver Omniscience:** Non-free and Contrib repositories are enabled by default; firmware is auto-detected and installed.
- **No "Sticky Key" Nagging:** Accessibility shortcuts that interrupt gaming/work are disabled by default.

## 3. CORE ARCHITECTURE (C++20 MODULES)

The OS is orchestrated by a single static binary: **The Heartbeat**.

- **The Healer:** A background watchdog that restarts crashed services and prevents disk exhaustion (Zip bombs/Log overflows).
- **The Vault:** Native AES-256-XTS encrypted containers (LUKS2) compatible with standard Linux tools.
- **The Instinct:** Includes "Furry BASIC" (Educational Compiler) and "FoxServe" (Zero-config Web Server).
- **The Session:** A native TTY multiplexer (F1-F12 HUD) replacing `tmux` complexity.

## 4. ASSET PROVENANCE

- **Library:** 9GB "AnthroHeart Collection" included in the ISO.
- **Verification:** SHA-256 hash anchored to Bitcoin Block **929481**.
- **Access:** Hidden in `/root/TOP` until unlocked via the Heartbeat Dashboard.

## 5. OMNI-MODE CAPABILITY

Users can toggle features on the fly:

- **Granny Mode:** Auto-repair UI, no CLI.
- **Furry Mode:** Creative Suite (Krita, Blender) + Asset Link.
- **Power User / Crypto:** Kernel tuning (BBR), Process Priority, Dev Tools.
- **Military / Paranoid:** Network Kill-switch, Forensic Wipe, Stealth Firewall.

## 6. MEDIA & TOOLS

- **Editors:** VSCodium (Code), Pinta (Image), Audacity (Audio).
- **Game:** Fox's Gem Hunt (Localhost).
- **File Manager:** AnthroFM (Grassroots, Absolute Paths, No Breadcrumbs).
- **Search:** Omni-Indexer (Instant file retrieval).

# <!--

(c) 2019–2025 Anthro Entertainment LLC | All Rights Reserved.
"This isn't about me, it's a starting point."
===============================================================================
-->
